/****** Object:  StoredProcedure [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA_EXECUTE_ALL]    Script Date: 02/10/2014 18:47:24 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA_EXECUTE_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA_EXECUTE_ALL]

GO 
-- EXECUTE  
--EXEC P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA_EXECUTE_ALL 
CREATE PROCEDURE [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA_EXECUTE_ALL] AS
	SET NOCOUNT ON

	DECLARE @CD_EMP INT
	DECLARE @CD_FORN INT
	DECLARE @CD_CTR_GRUPO INT

	UPDATE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
	SET
		FLAG_FECHAR_VERBA = 1
	WHERE
		FLAG_FECHAR_VERBA = 0
		AND CONVERT(DATE, GETDATE()) BETWEEN DT_INI AND DT_FIM 


	DECLARE FndFechamento CURSOR FAST_FORWARD FOR 
	SELECT
		PG_FORN_RC_CLI.CD_EMP,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_FORN
		
	FROM
		CG_FND_VERBA_NOTA_CREDITO_GRUPO 
		INNER JOIN PG_FORN_RC_CLI ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_EMP = PG_FORN_RC_CLI.CD_EMP AND
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_FORN = PG_FORN_RC_CLI.CD_FORN 
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.FLAG_FECHAR_VERBA = 1
	GROUP BY
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_FORN,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
		PG_FORN_RC_CLI.CD_EMP
		
		
	OPEN FndFechamento
	FETCH NEXT FROM FndFechamento INTO @CD_EMP, @CD_CTR_GRUPO, @CD_FORN
		WHILE @@FETCH_STATUS=0
		  BEGIN
			PRINT 'Fornecedor ' + CONVERT(VARCHAR, @CD_FORN) 
		
			EXEC P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA @CD_EMP, @CD_CTR_GRUPO, @CD_FORN

			FETCH NEXT FROM FndFechamento INTO @CD_EMP, @CD_CTR_GRUPO, @CD_FORN
		  END

	PRINT 'Concluido.'
	CLOSE FndFechamento;
	DEALLOCATE FndFechamento;

UPDATE
	CG_FND_VERBA_NOTA_CREDITO_GRUPO
SET
	FLAG_FECHAR_VERBA=2
WHERE
	FLAG_FECHAR_VERBA = 1
	AND CONVERT(DATE, GETDATE()) > DT_FIM 
GO


